<%@ Page Title="TBI Instruments - Instrument Associations" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="Instrument.aspx.cs" Inherits="TBI_Instrument" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

    <style type="text/css">
            .breadcrumbInstrument {
                background-color:#6B1424;
                border-bottom:1px solid #000;
                color:#FFF;
                font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
                font-variant:small-caps;
                font-weight:700;
                letter-spacing:1px;
                margin: 2px 0 2px 0;
                padding:8px 25px 5px 10px;
            }
    </style>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
<asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeOut="700" runat="server">
    </asp:ScriptManager>
      
    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        function startRequest(sender, e) {
            //disable button during the AJAX call
            try {
                var el = document.getElementById('<%=PanelObjectContent.ClientID%>');
                if (el != null) {
                    el.disabled = true;

                    var el1 = document.getElementById('<%=ButtonContinue.ClientID%>');
                    if (el1 != null) {
                        el1.style.display = 'none';
                    }
                }
            } catch (err) {
                // nothing
                alert('Error: ' + err);
            }
        }

        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            try {
                var el = document.getElementById('<%=PanelObjectContent.ClientID%>');
                if (el != null) {
                    el.disabled = false;
                }
            } catch (err) {
            // nothing
            alert('Error: ' + err);
            }
        }
        
    </script>
        
<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
<script type = "text/javascript">

    $(document).ready(function() {
        //event   section

        //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
        $('input').keydown(function(e) {
            if (e.keyCode == 13) { return false; }
        });

        //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed 
        $('div').keydown(function(e) {
            if (e.keyCode == 13) { return false; }
        });

        $(function() {

            //            if ($('#<%= LocationIdField.ClientID  %>').val() == '0') {
            //                $('#<%= RadioButtonListEncounterType.ClientID %> input[value = 2]').closest('tr').hide();

            //            }

            if ($('#<%= RadioButtonListEncounterType.ClientID %> input:checked').length > 0)

                $('#<%= ButtonContinue.ClientID %>').show();
            else

                $('#<%= ButtonContinue.ClientID %>').hide();

            $('#<%= RadioButtonListEncounterType.ClientID %>').click(function(e) {
                $('#<%= ButtonContinue.ClientID %>').hide();

            });

        });

    });

        
    
    </script> 
    </telerik:RadCodeBlock>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock2"> 
<asp:HiddenField runat = "server" ID = "LocationIdField" Value = "0" />
         <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations"></asp:Label> 
        </div>
</telerik:RadCodeBlock>
<telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
<asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                <ProgressTemplate>
                    <!-- Modal Popup for Loading -->
                  <div style="padding-left: 3px;" >
                        <div style="background-color: #FF0000; width: 300px; color: #FFFFFF; padding: 5px;">
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                        </div>
                    </div>
                  
                    <!-- End Modal Popup for Loading -->
                </ProgressTemplate>
            </asp:UpdateProgress>
<asp:UpdatePanel ID="MainUpdatePanel" runat="server">
    <ContentTemplate> 
        <div class = "excludeSaveWarnings">     
            <asp:Panel ID="PanelObjectContent" runat="server">
                 
                    <br />
                    <asp:Table ID="tblInstrumentAssociations" runat="server" CellPadding="3" CellSpacing="3" BorderWidth="0" Width="100%">
                        <asp:TableRow>
                            <asp:TableCell>
                                <asp:Panel ID="PanelPatientSelectInstrument" Width="100%"
                                      GroupingText="Patient&nbsp;&nbsp;" runat="server">
                                <br />
                                &nbsp;&nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label>
                                <br />
                                <br />
                                </asp:Panel>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow ID="tableRowInstrumentTypeLabel" runat="server">
                            <asp:TableCell>
                                <asp:Label ID="LabelforLabelInstrumentType" runat="server" 
                                    AssociatedControlID="LabelInstrumentType" SkinID="DataLabel">Instrument Type:</asp:Label>
                                <br />
                                <asp:Label ID="LabelInstrumentType" runat="server" SkinID="DataLabel"></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow ID="tableRowInstrumentTypeDropDown" runat="server">
                            <asp:TableCell>
                                <asp:Table ID="Table1" runat="server"  >
                                <asp:TableRow>
                                    <asp:TableCell>&nbsp;
                                        <asp:Label ID="LabelforDropDownListNoteTitleId" runat="server" AssociatedControlID="DropDownListNoteTitleId">Select Note Title *: </asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell>&nbsp;
                                        <asp:Label ID="lblStartsWith" runat="server" AssociatedControlID="txtNoteSearchFilter">Starts With: </asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell>&nbsp;</asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow>
                                    <asp:TableCell>
                                        <asp:DropDownList ID="DropDownListNoteTitleId" 
                                            CssClass="tbiReferralDropDownListWidth"
                                            Width="600px"
                                            runat="server" 
                                            AutoPostBack="True" 
                                            onselectedindexchanged="DropDownListNoteTitleId_SelectedIndexChanged"
                                            DataTextField="Value" 
                                            DataValueField="Key"
                                            AppendDataBoundItems="true">
                                            <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                        </asp:DropDownList>
                                     </asp:TableCell>
                                     <asp:TableCell>&nbsp;
                                        <asp:TextBox ID="txtNoteSearchFilter" Width="85px" runat="server"  /><!-- OnTextChanged="Filter_NoteSearch" autopostback="true"-->
                                     </asp:TableCell>
                                     <asp:TableCell>&nbsp;
                                        <asp:Button ID="btnFilterNotes" UseSubmitBehavior = "true" Width="55px" runat="server" Text="Filter" ToolTip="Filter Note Titles" CausesValidation="true" style="cursor:hand" ValidationGroup="OnSave" OnClick="Filter_NoteSearch" />
                                     </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow>
                                    <asp:TableCell>&nbsp;
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListNoteTitleId"
                                            ControlToValidate="DropDownListNoteTitleId"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Note Title is required."
                                            SetFocusOnError="true"
                                            InitialValue="0" />
                                    </asp:TableCell>
                                    <asp:TableCell>&nbsp;</asp:TableCell>
                                    <asp:TableCell>&nbsp;</asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow>
                                    <asp:TableCell>&nbsp;
                                        <asp:Label ID="LabelforDropDownListConsult" runat="server" AssociatedControlID="DropDownListConsult" Visible="false" />
                                        <br />
                                        <asp:DropDownList ID="DropDownListConsult" 
                                            CssClass="tbiReferralDropDownListWidth"
                                            Width="600px"
                                            runat="server" 
                                            AutoPostBack="false" 
                                            DataTextField="Value" 
                                            DataValueField="Key"
                                            Visible = "false" 
                                            AppendDataBoundItems="true">
                                            <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                        </asp:DropDownList>  
                                        &nbsp;&nbsp;
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListConsult"
                                            ControlToValidate="DropDownListConsult"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Link to Consult is required."
                                            SetFocusOnError="true"
                                            InitialValue="0">
                                        </asp:RequiredFieldValidator> 
                                    </asp:TableCell>
                                    <asp:TableCell>&nbsp;</asp:TableCell>
                                    <asp:TableCell>&nbsp;</asp:TableCell>
                                </asp:TableRow>
                                </asp:Table>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell>
                                <asp:Panel ID="PanelLinkVisit" Width="300px" GroupingText="Link to Encounter Type&nbsp;&nbsp;" runat="server">
                                    <asp:RadioButtonList ID="RadioButtonListEncounterType" runat="server" 
                                        AutoPostBack="True"  
                                        onselectedindexchanged="RadioButtonListEncounterType_SelectedIndexChanged" >
                                        <asp:ListItem Selected="True" Value="0">Scheduled Clinic Appointment</asp:ListItem>    
                                        <asp:ListItem Value="1">Hospital Admission</asp:ListItem>    
                                        <asp:ListItem Value="2">Current Stay</asp:ListItem>    
                                        <asp:ListItem Value="3">Unscheduled or New Visit</asp:ListItem>    
                                    </asp:RadioButtonList>
                                </asp:Panel>
                                 <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxUsername" runat="server" 
                                    ControlToValidate="RadioButtonListEncounterType" 
                                    ErrorMessage="Link to Encounter Type is required"
                                    SetFocusOnError="true">
                                </asp:RequiredFieldValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRowClinicAppointment">
                            <asp:TableCell>
                                <asp:Label ID="LabelforDropDownListScheduledClinicAppointment" runat="server" 
                                    AssociatedControlID="DropDownListScheduledClinicAppointment">
                                    Select the Scheduled Clinic Appointment:
                                </asp:Label>
                                <br />
                                <asp:DropDownList ID="DropDownListScheduledClinicAppointment" 
                                    CssClass="tbiReferralDropDownListWidth"
                                    Width="500px"
                                    runat="server" 
                                    AutoPostBack="false" 
                                    DataTextField="Value" 
                                    DataValueField="Key"
                                    AppendDataBoundItems="true">
                                    <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                </asp:DropDownList>
                                &nbsp;&nbsp;
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListScheduledClinicAppointment"
                                    ControlToValidate="DropDownListScheduledClinicAppointment"
                                    Display="Static"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Scheduled Clinic Appointment is required."
                                    SetFocusOnError="true"
                                    InitialValue="0">
                                </asp:RequiredFieldValidator> 
                                <br />
                                <asp:Panel ID="PanelAppointmentFilter" Width="80%" GroupingText="Modify Appointment Filter&nbsp;&nbsp;" runat="server">
                                    <asp:Label ID="Label1" runat="server" SkinID="DataLabel">
                                    Your site's VistA system was searched to find scheduled clinic appointments. The period of time one month before today and one month after today was used for this search.  If any appointments were found, these are loaded in the dropdown above.  Select an appointment to proceed to the next step.  If you would like to expand the date range to search, change the start and/or end dates and click "Get Appointments", then select to proceed to next step.
                                    </asp:Label>
                                    <br />
                                    <br />
                                    <table>
                                        <tr>
                                            <td>
                                                <asp:Label ID="LabelForTextBoxAppointmentSearchDateStart" runat="server" 
                                                    AssociatedControlID="TextBoxAppointmentSearchDateStart" SkinID="DataLabel">
                                                     Start (mm/dd/yyyy):
                                                </asp:Label>
                                            </td>
                                            <td>
                                                <asp:Label ID="LabelforTextBoxAppointmentSearchDateEnd" runat="server" 
                                                    AssociatedControlID="TextBoxAppointmentSearchDateEnd" SkinID="DataLabel">
                                                     End (mm/dd/yyyy):
                                                </asp:Label>
                                            </td>
                                            <td>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="TextBoxAppointmentSearchDateStart" runat="server"/>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                <br />
                                                 <asp:CompareValidator ID = "AppointmentDateStartValidator" runat = "server" EnableClientScript = "true" 
                                                     SetFocusOnError="true" 
                                                     ControlToValidate = "TextBoxAppointmentSearchDateStart"
                                                     ValidationGroup="OnSave" Type = "Date" Operator = "DataTypeCheck"  
                                                     ErrorMessage = "Start date must be a valid date" Display = "Static">                                             
                                                 </asp:CompareValidator>
                                            </td>
                                            <td>
                                                <asp:TextBox ID="TextBoxAppointmentSearchDateEnd" runat="server"/>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                <br />
                                                <asp:CompareValidator ID = "AppointmentDateEndValidator" runat = "server" EnableClientScript = "true" 
                                                     SetFocusOnError="true" 
                                                     ControlToValidate = "TextBoxAppointmentSearchDateEnd"
                                                     ValidationGroup="OnSave" Type = "Date" Operator = "DataTypeCheck"  
                                                     ErrorMessage = "End date must be a valid date" Display = "Static">                                             
                                                 </asp:CompareValidator>
                                            </td>
                                            <td>
                                                <asp:Button ID="ButtonFilterAppointments" UseSubmitBehavior = "true" Width="130px" runat="server" Text="Get Appointments" ToolTip="Filter Appointments" CausesValidation="true" style="cursor:hand" ValidationGroup="OnSave" OnClick="ButtonFilterAppointments_Click" />
                                                &nbsp;&nbsp;&nbsp;&nbsp;
                                                <asp:CompareValidator ID = "AppointmentDateCompareValidator" runat = "server" EnableClientScript = "true" 
                                                     SetFocusOnError="true" 
                                                     ControlToValidate = "TextBoxAppointmentSearchDateEnd"
                                                     ControlToCompare = "TextBoxAppointmentSearchDateStart"
                                                     ValidationGroup="OnSave" Type = "Date" Operator ="GreaterThan"  
                                                     ErrorMessage = "End date must be greater than start date" Display = "Dynamic">                                             
                                                 </asp:CompareValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRowHospitalAdmission">
                            <asp:TableCell>
                                    <asp:Label ID="LabelforDropDownListHospitalAdmission" runat="server" 
                                    AssociatedControlID="DropDownListHospitalAdmission">
                                    Select the Hospital Admission:
                                </asp:Label>
                                <br />
                                <asp:DropDownList ID="DropDownListHospitalAdmission" 
                                    CssClass="tbiReferralDropDownListWidth"
                                    Width="500px"
                                    runat="server" 
                                    AutoPostBack="false" 
                                    DataTextField="Value" 
                                    DataValueField="Key"
                                    AppendDataBoundItems="true">
                                    <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                </asp:DropDownList>
                                &nbsp;&nbsp;
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListHospitalAdmission"
                                    ControlToValidate="DropDownListHospitalAdmission"
                                    Display="Static"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Hospital Admission is required."
                                    SetFocusOnError="true"
                                    InitialValue="0">
                                </asp:RequiredFieldValidator> 
                                <br />
                                <asp:Label ID="LabelHospitalAdmissionNote" runat="server">
                                    Your site's VistA system was searched for previous stays.  If any were found they are loaded in the drop down above.  If no previous stays are found for this patient, you must select a different choice in the section "Link to Encounter Type" to proceed.
                                </asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRowUnscheduledNewVisitLocation">
                            <asp:TableCell>
                                <asp:Label ID="LabelforDropDownListUnscheduleNewVisitLocation" runat="server" 
                                    AssociatedControlID="DropDownListUnscheduleNewVisitLocation">
                                    Location:
                                </asp:Label>
                                <br />
                                <asp:CheckBox runat="server" ID="CheckBoxUnscheduledNewVisitHistorical" Text="Historical">
                                    </asp:CheckBox>
                                &nbsp;&nbsp;
                                <asp:DropDownList ID="DropDownListUnscheduleNewVisitLocation" 
                                    CssClass="tbiReferralDropDownListWidth"
                                    Width="500px"
                                    runat="server" 
                                    AutoPostBack="false" 
                                    DataTextField="Value" 
                                    DataValueField="Key"
                                    AppendDataBoundItems="true">
                                    <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                </asp:DropDownList>
                                &nbsp;&nbsp;
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListUnscheduleNewVisitLocation"
                                    ControlToValidate="DropDownListUnscheduleNewVisitLocation"
                                    Display="Static"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Location is required."
                                    SetFocusOnError="true"
                                    InitialValue="0">
                                </asp:RequiredFieldValidator>
                                <br />
                                <asp:Panel ID="PanelNewVisitNote" Width="80%" GroupingText="Location&nbsp;&nbsp;" runat="server">
                                  
                                    <asp:Label ID="Label2" runat="server" SkinID="DataLabel">
                                    Your site's VistA system was searched to find all locations at your site which begin with the search string "TBI".  If any locations were found, they are loaded in the dropdown above.  If you would like to use a different location, change the default search string below and click "Get Locations".  After selecting a location, you can proceed to the next step.
                                    </asp:Label>
                                    <br />
                                    <br />
                                    <table>
                                        <tr>
                                            <td Width="130px"></td>
                                            <td>
                                                <asp:Label ID="LabelforTextBoxLocationSearchString" runat="server" 
                                                    AssociatedControlID="TextBoxLocationSearchString" SkinID="DataLabel">
                                                     Location Search String:
                                                </asp:Label>
                                            </td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td Width="130px"></td>
                                            <td>
                                                <asp:TextBox ID="TextBoxLocationSearchString" runat="server"/>
                                            </td>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                            <td style="vertical-align:bottom">
                                                <asp:Button ID="ButtonGetLocations" UseSubmitBehavior = "true" Width="130px" runat="server" Text="Get Locations" ToolTip="Get Locations" CausesValidation="true" style="cursor:hand" ValidationGroup="OnSave" OnClick="ButtonGetLocations_Click" />
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRowCosigner">
                            <asp:TableCell>
                                <asp:Label ID="CosignerListLabel" runat="server" 
                                    AssociatedControlID="DropDownListCosigner">
                                    Cosigner:
                                </asp:Label>
                                &nbsp;&nbsp;
                                <asp:DropDownList ID="DropDownListCosigner" 
                                    CssClass="tbiReferralDropDownListWidth"
                                    Width="500px"
                                    runat="server" 
                                    AutoPostBack="false" 
                                    DataTextField="Value" 
                                    DataValueField="Key"
                                    AppendDataBoundItems="true">
                                    <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                                </asp:DropDownList>
                                &nbsp;&nbsp;
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator_DropDownListCosigner"
                                    ControlToValidate="DropDownListCosigner"
                                    Display="Static"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Cosigner is required."
                                    SetFocusOnError="true"
                                    InitialValue="0">
                                </asp:RequiredFieldValidator>
                                <br />
                                <asp:Panel ID="PanelCosigner" Width="80%" 
                                  GroupingText="Cosigner&nbsp;&nbsp;" runat="server">
                                    <asp:Label ID="Label3" runat="server" SkinID="DataLabel">
                                    Please enter the name of your cosigner and click "Get CPRS Users".  If any matches beginning with the specified search string are found within your site's VistA system, they will be loaded in the dropdown list above.
                                    </asp:Label>
                                    <br />
                                    <br />
                                    <table>
                                        <tr>
                                            <td Width="130px"></td>
                                            <td>
                                                <asp:Label ID="CosignerSearchLabel" runat="server" 
                                                    AssociatedControlID="TextBoxCosignerSearch" SkinID="DataLabel">
                                                     Cosigner Name Search:
                                                </asp:Label>
                                            </td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                            <td Width="130px"></td>
                                            <td>
                                                <asp:TextBox ID="TextBoxCosignerSearch" runat="server"/>
                                            </td>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                            <td style="vertical-align:bottom">
                                                <asp:Button ID="ButtonGetCPRSUsers" UseSubmitBehavior = "true" Width="130px" runat="server" Text="Get CPRS Users" ToolTip="Get CPRS Users" CausesValidation="true" style="cursor:hand" ValidationGroup="OnSave" OnClick="ButtonGetCPRSUsers_Click" />
                                            </td>
                                       <tr>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell>
                                <asp:Button ID="ButtonContinue" UseSubmitBehavior = "true" Width="130px" 
                                    runat="server" Text="Continue" ToolTip="Continue" CausesValidation="true" 
                                    style="cursor:hand" onclick="ButtonContinue_Click" />
                    
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>               
            </asp:Panel>
    
            <asp:Panel ID = "ErrorPanel" runat = "server" Visible = "false">
                <center>
                    <br />
                    <br />
                    <br />    
                    <h2 style = "font-size:large;color:Red" >
                        <asp:Literal ID = "MDWSCallError" runat = "server"></asp:Literal> 
                    </h2>
               </center>
            </asp:Panel>     
        
            </div>
            
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>

